## 概述

### SF512x运动学变换器

本产品是一款专为工业自动化应用设计的高性能运动学变换工具，将机器人控制与传统PLC集成于单一系统。通过在同一系统内实现整个控制功能，消除了PLC、运动控制和机器人控制之间不同CPU接口导致的性能损失。

本产品提供高精度的正向运动学与逆向运动学计算功能，支持4D-SCARA机器人在复杂工作环境中的精确位置和姿态控制。通过参数化设计，支持多种机器人配置，包括臂长、角度范围、负载能力等，以适应不同工作需求。

---

### 坐标系概述

在描述系统的运动和位置行为时，坐标系是必不可少的。以下是常用的几种坐标系及其特点：

* 机械坐标系(MCS - Machine Coordinate System)是以机器人为基础的笛卡尔坐标系，通常原点位于机器人的基座上。

* 世界坐标系(WCS - World Coordinate System)是描述整个建模“世界”的笛卡尔坐标系，与特定机器人无直接关联。机器人机械坐标系 (MCS) 的原点位于世界坐标系中的某一特定点，用户可以定义机器人在“世界”中的位置和朝向。一个WCS可包含多个机器人。使用机器人时，世界坐标系与机械坐标系可以重合，以提高透明度。

* 工件坐标系(PCS -  Program Coordinate System)可以在世界坐标系内的任意位置和任意方向进行设置。适合于复杂工作环境，比如多个工作区域或多个工件操作的场景。

* 轴坐标系 (ACS - Axis Coordinate System)描述机器人物理轴的运动位置，通常不是笛卡尔坐标系。许多机器人关节轴以旋转运动为主，因此轴坐标系更适合描述旋转角度、速度和加速度的极限值。轴坐标系通常用于参考点定位（参考/归位操作）。

---

### 运动学中的坐标变换

在工业机器人编程中，通常以机械坐标系 (MCS)为基础。由于人类更直观地使用笛卡尔坐标系（如X、Y、Z轴）进行思考和规划，因此在执行运动时，必须在轴坐标系 (ACS) 和笛卡尔空间之间进行坐标转换。

运动学中的变换描述了从一个坐标系切换到另一个坐标系所需的计算过程。机器人运动学中的坐标变换主要涉及以下两种情况：

* 正向变换是指从轴坐标系 (ACS) 到笛卡尔坐标系的转换。刀具中心点 （TCP） 的笛卡尔位置是根据机器人的轴特定关节坐标计算得出的。

* 逆向变换是指将笛卡尔坐标系中的TCP位置转换到轴坐标系 (ACS)。为了驱动机器人实际运动，需要将期望的TCP位置和姿态转化为每个关节的轴坐标参数。

---

### 4D-SCARA机器人(S\_CCZC)

![](https://resource.helplook.net/docker_production/3648ne/article/ji5eTYbs/680ef1722b6f0.png)


4D-SCARA（选择性顺应装配机器人臂）是一种具有四自由度（DOF）的机器人，其运动学结构和电机轴配置如图所示。电机轴M1、M2和M4为旋转轴，单位为角度（°），箭头指示其正向旋转方向。第三个电机轴M3为线性轴，单位为毫米（mm），用于实现垂直方向的运动。

机械坐标系（MCS）的原点位于第一个关节（M1）处。当所有旋转电机轴（M1、M2、M4）均处于0°时，SCARA机械臂指向的方向即为X轴。此配置定义了MCS的X轴方向，Y轴与X轴垂直，形成一个右手笛卡尔坐标系，Z轴则为垂直方向，与M3的线性运动一致。

这种配置方式确保了高精度的路径规划和运动控制，并为机器人在工业任务中的高效表现提供了基础。

---
### 安装卸载

**安装要求**

本节描述工程和/或运行时系统所需的最低要求。

**1、硬件要求**

支持 MetaFacture 平台的设备（ PLC 或嵌入式系统）。

**2、软件要求**

已安装 MetaFacture 的开发环境。

操作系统支持：MetaOS或其他兼容平台。

必须具备相关的库或模块依赖（如基础 I/O 库）

**安装过程**

**1、通过库管理器安装**

在 MetaFacture 中打开工程项目。

通过菜单选择“工具”->“库存储”。
![](https://resource.helplook.net/docker_production/3648ne/article/ji5eTYbs/680ef1a7a5ef2.png)


点击安装，打开 **Kinematics** 库文件。
![](https://resource.helplook.net/docker_production/3648ne/article/ji5eTYbs/680ef1c3e5056.png)

![](https://resource.helplook.net/docker_production/3648ne/article/ji5eTYbs/680ef1d14c060.png)

打开成功，关闭窗口。

点击”添加库“
![](https://resource.helplook.net/docker_production/3648ne/article/ji5eTYbs/680ef1ded62f2.png)


选&#x4E2D;**&#x20;Kinematics&#x20;**，点击确&#x5B9A;**。**
![](https://resource.helplook.net/docker_production/3648ne/article/ji5eTYbs/680ef1e96de4c.png)


**更新安装**

**1、覆盖安装**

下载最新版本的 Kinematics 库文件。

打开 MetaFacture 工程，在“库管理器”中删除旧版本的库，导入新版本库文件。

保存工程并重新编译。

**2、版本兼容性验证**

检查新版本是否与现有工程兼容。

根据文档调整旧版本与新版本可能的差异。

**卸载过程**

**1、通过库管理器卸载**

打开 MetaFacture 项目，进入“库管理器”。

选择 Kinematics 库，点击“删除库”卸载库文件。

2、**清理项目依赖**

打开工程项目，检查并移除所有使用 Kinematics 库的功能块或接口。

确保工程重新编译时无报错。